/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.compatibility.jei.transfer;

import com.google.common.collect.ImmutableSet;
import com.minecolonies.api.inventory.container.ContainerCrafting;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.coremod.Network;
import com.minecolonies.coremod.network.messages.server.TransferRecipeCraftingTeachingMessage;
import java.util.Collection;
import java.util.HashMap;
import javax.annotation.Nullable;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.ingredient.IGuiIngredient;
import mezz.jei.api.gui.ingredient.IGuiItemStackGroup;
import mezz.jei.api.recipe.transfer.IRecipeTransferError;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandler;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandlerHelper;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import org.jetbrains.annotations.NotNull;

public class PrivateCraftingTeachingTransferHandler
implements IRecipeTransferHandler<ContainerCrafting> {
    private final IRecipeTransferHandlerHelper handlerHelper;

    public PrivateCraftingTeachingTransferHandler(@NotNull IRecipeTransferHandlerHelper handlerHelper) {
        this.handlerHelper = handlerHelper;
    }

    @NotNull
    public Class<ContainerCrafting> getContainerClass() {
        return ContainerCrafting.class;
    }

    @Nullable
    public IRecipeTransferError transferRecipe(@NotNull ContainerCrafting craftingGUIBuilding, @NotNull Object recipe, @NotNull IRecipeLayout recipeLayout, @NotNull PlayerEntity player, boolean maxTransfer, boolean doTransfer) {
        ImmutableSet badIndexes;
        IGuiItemStackGroup itemStackGroup = recipeLayout.getItemStacks();
        HashMap<Integer, ItemStack> guiIngredients = new HashMap<Integer, ItemStack>();
        guiIngredients.put(0, ItemStackUtils.EMPTY);
        guiIngredients.put(1, ItemStackUtils.EMPTY);
        guiIngredients.put(3, ItemStackUtils.EMPTY);
        guiIngredients.put(4, ItemStackUtils.EMPTY);
        if (craftingGUIBuilding.isComplete()) {
            guiIngredients.put(2, ItemStackUtils.EMPTY);
            guiIngredients.put(5, ItemStackUtils.EMPTY);
            guiIngredients.put(6, ItemStackUtils.EMPTY);
            guiIngredients.put(7, ItemStackUtils.EMPTY);
            guiIngredients.put(8, ItemStackUtils.EMPTY);
            badIndexes = ImmutableSet.of();
        } else {
            badIndexes = ImmutableSet.of((Object)2, (Object)5, (Object)6, (Object)7, (Object)8);
        }
        int inputIndex = 0;
        for (IGuiIngredient ingredient : itemStackGroup.getGuiIngredients().values()) {
            if (!ingredient.isInput()) continue;
            if (!ingredient.getAllIngredients().isEmpty()) {
                if (badIndexes.contains(inputIndex)) {
                    TranslationTextComponent tooltipMessage = new TranslationTextComponent("jei.tooltip.error.recipe.transfer.too.large.player.inventory");
                    return this.handlerHelper.createUserErrorForSlots((ITextComponent)tooltipMessage, (Collection)badIndexes);
                }
                guiIngredients.put(inputIndex, (ItemStack)ingredient.getDisplayedIngredient());
            }
            ++inputIndex;
        }
        if (doTransfer) {
            CraftingInventory craftMatrix = craftingGUIBuilding.getInv();
            if (craftingGUIBuilding.isComplete()) {
                craftMatrix.func_70299_a(0, (ItemStack)guiIngredients.get(0));
                craftMatrix.func_70299_a(1, (ItemStack)guiIngredients.get(1));
                craftMatrix.func_70299_a(2, (ItemStack)guiIngredients.get(2));
                craftMatrix.func_70299_a(3, (ItemStack)guiIngredients.get(3));
                craftMatrix.func_70299_a(4, (ItemStack)guiIngredients.get(4));
                craftMatrix.func_70299_a(5, (ItemStack)guiIngredients.get(5));
                craftMatrix.func_70299_a(6, (ItemStack)guiIngredients.get(6));
                craftMatrix.func_70299_a(7, (ItemStack)guiIngredients.get(7));
                craftMatrix.func_70299_a(8, (ItemStack)guiIngredients.get(8));
            } else {
                craftMatrix.func_70299_a(0, (ItemStack)guiIngredients.get(0));
                craftMatrix.func_70299_a(1, (ItemStack)guiIngredients.get(1));
                craftMatrix.func_70299_a(2, (ItemStack)guiIngredients.get(3));
                craftMatrix.func_70299_a(3, (ItemStack)guiIngredients.get(4));
            }
            TransferRecipeCraftingTeachingMessage message = new TransferRecipeCraftingTeachingMessage(guiIngredients, craftingGUIBuilding.isComplete());
            Network.getNetwork().sendToServer(message);
        }
        return null;
    }
}

